<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class adminController extends Controller
{
    public function showUsers(){
        $users = json_decode(DB::table('users')->where(['role'=>'user'])->get());
        return response()->json($users);
    }

    public function showSchedules(){
        $schedules = json_decode(DB::table('schedules')->get());
        return response()->json($schedules);
    }

    public function deleteUser(Request $request)
    {
        $uid = $request->route('id');
        $schedules = json_decode(DB::table('schedules')->where(['user_id'=>$uid])->get());

        foreach($schedules as $schedule){
            DB::table('schedule_dates')->where(['schedule_id'=>$schedule['id']])->dalate();
            DB::table('participants')->where(['schedule_id'=>$schedule['id']])->delete();
            DB::table('participant_date')->where(['schedule_id'=>$schedule['id']])->delete();
        }
        $pids = json_decode(DB::table('participants')->where(['user_id'=>$uid])->get());

        foreach($pids as $pid){
            DB::table('participant_dates')->where(['participant_id', $pid['id']])->delete();
        }
        DB::table('participants')->where(['user_id', $uid]);
        DB::table('schedules')->where(['user_id'=>$uid])->delete();
        DB::table('users')->where(['id'=>$uid])->delete();

        return 'success';
    }

    public function deleteSchedule(Request $request)
    {
        $id = $request->route('id');
        error_log(print_r($id, true));
        DB::table('participant_date')->where(['schedule_id'=>$id])->delete();
        DB::table('participants')->where(['schedule_id'=>$id])->delete();
        DB::table('schedule_dates')->where(['schedule_id'=> $id])->delete();
        DB::table('schedules')->where(['id'=> $id])->delete();

        return 'success';
    }

    public function changePassword(Request $request)
    {
        $user = json_decode(DB::table('users')->where(['id'=>$request['userid']])->get());
        $oldpass = $request['current_pass'];
        error_log(print_r(bcrypt($oldpass), true));
        error_log(print_r(Hash::check($oldpass, $user[0]->password), true));
        if(Hash::check($oldpass, $user[0]->password)){
            DB::table('users')->where(['id'=>$request['userid']])->update(['password'=>bcrypt($request['password'])]);
            return 'success';
        }
        return 'failed';
    }

    public function mail(Request $request)
    {
        $id = $request->route('id');
        $mail = json_decode(DB::table('mails')->where(['catagory'=>$id])->get());

        return response()->json(['Mail'=>$mail]);
    }

    public function updateMail(Request $request)
    {
        DB::table('mails')->where(['catagory'=>$request['catagory']])->update(['subject'=>$request['subject'], 'body'=>$request['body']]);
        return 'success';
    }
}
