<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateScheduleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id');
            $table->string('title');
            $table->string('location');
            $table->text('description');
            $table->integer('theme');
            $table->enum('reply_deadline',['yes','no']);
            $table->date('reply_deadline_date')->nullable();
            $table->enum('if_needed_option',['yes','no']);
            $table->enum('one_answer',['yes','no']);
            $table->enum('hidden_schedule',['yes','no']);
            $table->enum('ask_for_contact',['yes','no']);
            $table->enum('limit_access',['yes','no']);
            $table->string('schedule_link')->nullable();
            $table->timestamp('publish_time')->nullable();
            $table->time('closing_time')->nullable();
            $table->time('chosen_time')->nullable();
            $table->enum('status',['yes','no']);
            $table->timestamps();

            //$table->foreign('user_id')->references('id')->on('users');
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('schedule');
    }
}
